/* Replication code for Quantifying Economic Policy, section on government spending data */


/* To generate table in Appendix 3.2, and table */

use "cofogukwide.dta"


/* Changes 95-19 */
reshape long y, i(category) j(year)
generate y_ref = y if category == "total"
encode category, gen(cat)

bysort year (cat): replace y_ref = y_ref[80]

generate y_prop = y/y_ref

xtset cat year

replace category = stritrim(category)
replace category = strltrim(category)

/* Main results, Newey-West regression*/
bysort cat: asreg y_prop year, se newey(2) /* 25^(1/4)) */

keep cat _*

bysort cat : keep if _n == _N

gen _t_year = _b_year/_se_year

gen _sig_t_year = 1 if abs(_t_year)>=1.96

sort _b_year

gen _b_year_perc = _b_year*100
gen _se_year_perc = _se_year*100

edit cat _b_year_perc _se_year_perc _t_year



* Changes from 95 to 05 */

reshape long y, i(category) j(year)
generate y_ref = y if category == "total"
encode category, gen(cat)

bysort year (cat): replace y_ref = y_ref[80]

generate y_prop = y/y_ref

xtset cat year

replace category = stritrim(category)
replace category = strltrim(category)


bysort cat: asreg y_prop year, se newey(2) /* 10^(1/4)) */

keep cat _*

bysort cat : keep if _n == _N

gen _t_year = _b_year/_se_year

gen _sig_t_year = 1 if abs(_t_year)>=1.96

sort _b_year

gen _b_year_perc = _b_year*100
gen _se_year_perc = _se_year*100

edit cat _b_year_perc _se_year_perc _t_year



xtline y_prop if category=="0101: Executive and legislative organs, financial, fiscal and external affairs" 
xtline y_prop if category=="0103: General services"

xtline y_prop if category=="0401: General economic, commercial and labour affairs"
xtline y_prop if category=="0408: RandD Economic affairs"


/* With extended dataset , going back to 1983 - Results in table 6*/

use "cofogukwideext.dta"

gen y1983=. 
gen y1984=. 
gen y1985=. 
gen y1986=. 
gen y1987=. 
gen y1988=. 
gen y1989=. 
gen y1990=. 
gen y1991=. 
gen y1992=. 
gen y1993=. 
gen y1994=.


order category y1983 y1984 y1985 y1986 y1987 y1988 y1989 y1990 y1991 y1992 y1993 y1994 


reshape long y, i(category) j(year)
generate y_ref = y if category == "total"
encode category, gen(cat)

bysort year (cat): replace y_ref = y_ref[6]

generate y_prop = y/y_ref

xtset cat year

replace category = stritrim(category)
replace category = strltrim(category)


bysort cat: asreg y_prop year, se newey(2) /* 10^(1/4)) */

keep cat _*

bysort cat : keep if _n == _N

gen _t_year = _b_year/_se_year

gen _sig_t_year = 1 if abs(_t_year)>=1.96

sort _b_year

gen _b_year_perc = _b_year*100
gen _se_year_perc = _se_year*100

edit cat _b_year_perc _se_year_perc _t_year

xtline y_prop if category=="0103: General services", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="0401: General economic, commercial and labour affairs", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="070: Health",  ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="090: Education",  ytitle(Proportion spending) ttitle(Year)

/* Graphs main groups  - Appendix */


reshape long y, i(category) j(year)
generate y_ref = y if category == "total"
encode category, gen(cat)

bysort year (cat): replace y_ref = y_ref[80]

generate y_prop = y/y_ref

xtset cat year

replace category = stritrim(category)
replace category = strltrim(category)

drop if category=="total"

xtline y_prop


xtline y_prop if category=="010: General public services", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="020: Defence", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="030: Public order and safety", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="040: Economic affairs", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="050: Environment protection", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="060: Housing and community amenities", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="070: Health", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="080: Recreation, culture and religion", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="090: Education", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="100: Social protection", ytitle(Proportion spending) ttitle(Year)


xtline y_prop if category=="1005: Unemployment", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="1006: Housing", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="0101: Executive and legislative organs, financial, fiscal and external affairs", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="0408: RandD Economic affairs", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="0403: Fuel and energy", ytitle(Proportion spending) ttitle(Year)
xtline y_prop if category=="0405: Transport", ytitle(Proportion spending) ttitle(Year)


